# 機能設計書 10-コード補完 (IntelliSense)

## 概要

本ドキュメントは、Roslynプラットフォームにおけるコード補完 (IntelliSense) の機能設計について記述する。コード補完は、開発者のコード入力を支援するため、コンテキストに応じた候補リストを提供するIDEの中核機能である。

### 本機能の処理概要

**業務上の目的・背景**：コード補完 (IntelliSense) は、開発者の生産性を大幅に向上させるIDEの重要機能である。入力中のコードのコンテキストを解析し、適切なシンボル、キーワード、スニペットなどの候補を提示することで、タイプミスの防止、API発見の促進、コーディング速度の向上を実現する。Roslynベースの実装により、高精度なセマンティック解析に基づく補完を提供している。

**機能の利用シーン**：
- ドット (.) 入力後のメンバー補完
- 型名入力時の型補完
- キーワード入力時の構文補完
- using文追加が必要な型のインポート補完
- スニペット展開
- 引数ヒント表示

**主要な処理内容**：
1. トリガー判定 (入力文字、明示的呼び出し)
2. コンテキスト解析 (構文位置、セマンティック情報)
3. CompletionProviderによる候補生成
4. フィルタリングとソート
5. 候補リストの返却
6. コミット処理 (選択時のコード挿入)

**関連システム・外部連携**：
- ワークスペース (Document/SemanticModel)
- Visual Studio/VS Code エディター
- リモートワークスペース (バックグラウンド処理)

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディター補完ポップアップ | 表示 | 候補リストの表示と選択 |

## 機能種別

言語サービス / エディター統合

## 入力仕様

### GetCompletionsAsync

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| caretPosition | int | Yes | キャレット位置 | 有効な位置 |
| trigger | CompletionTrigger | Yes | トリガー情報 | - |
| roles | ImmutableHashSet<string> | No | エディターロール | - |
| options | OptionSet | No | オプション | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### CompletionTrigger

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| Kind | CompletionTriggerKind | トリガー種別 |
| Character | char | トリガー文字 |

### CompletionTriggerKind

| 値 | 説明 |
|---|------|
| Invoke | 明示的呼び出し (Ctrl+Space等) |
| InvokeAndCommitIfUnique | 呼び出し+一意ならコミット |
| Insertion | 文字挿入トリガー |
| Deletion | 文字削除トリガー |

### 入力データソース

- Document (ソースコード)
- SemanticModel (セマンティック情報)
- MEFによるCompletionProvider読み込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionList | CompletionList | 補完候補リスト |
| CompletionItem | CompletionItem | 個別の補完候補 |
| CompletionDescription | CompletionDescription | 候補の説明 |

### CompletionItem主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| DisplayText | string | 表示テキスト |
| FilterText | string | フィルタリング用テキスト |
| SortText | string | ソート用テキスト |
| Span | TextSpan | 置換対象範囲 |
| Tags | ImmutableArray<string> | アイコン等のタグ |
| Properties | ImmutableDictionary | 追加プロパティ |

### 出力先

- IDE補完ポップアップ

## 処理フロー

### 処理シーケンス

```
1. トリガー検出
   └─ 文字入力またはCtrl+Space等の明示的呼び出し

2. ShouldTriggerCompletion判定
   └─ 各プロバイダーのトリガー条件確認

3. GetCompletionsAsync呼び出し
   └─ CompletionServiceがプロバイダーを呼び出し

4. プロバイダー実行
   └─ 各CompletionProviderが候補生成
   └─ コンテキスト解析
   └─ シンボル推奨

5. 結果マージ
   └─ 全プロバイダーの結果を統合
   └─ フィルタリングとソート

6. CompletionList返却
   └─ IDEに候補リストを返送

7. ユーザー選択
   └─ 候補選択後にGetChangeAsync
   └─ コード変更の生成
```

### フローチャート

```mermaid
flowchart TD
    A[文字入力/Ctrl+Space] --> B{ShouldTriggerCompletion?}
    B -->|No| C[終了]
    B -->|Yes| D[GetCompletionsAsync]
    D --> E[プロバイダー取得]
    E --> F[各プロバイダー実行]
    F --> G[ProvideCompletionsAsync]
    G --> H[コンテキスト解析]
    H --> I[シンボル推奨]
    I --> J[CompletionItem生成]
    J --> K{次のプロバイダー?}
    K -->|Yes| F
    K -->|No| L[結果マージ]
    L --> M[フィルタリング/ソート]
    M --> N[CompletionList返却]
    N --> O[IDEで表示]
    O --> P{ユーザー選択?}
    P -->|Yes| Q[GetChangeAsync]
    P -->|No| C
    Q --> R[コード変更適用]
    R --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ドットトリガー | "." 入力でメンバー補完をトリガー | C#/VB |
| BR-02 | 識別子トリガー | 英字入力で識別子補完をトリガー | TriggerOnTyping有効時 |
| BR-03 | 削除トリガー | 削除時も補完をトリガー可能 | TriggerOnDeletion有効時 |
| BR-04 | インポート補完 | 未参照の型も候補に含める | ShowItemsFromUnimportedNamespaces有効時 |
| BR-05 | スニペット | スニペットを候補に含める | SnippetsRule設定時 |

### CompletionOptions

| オプション | 説明 |
|-----------|------|
| TriggerOnTyping | 入力時に自動トリガー |
| TriggerOnDeletion | 削除時にトリガー |
| ShowItemsFromUnimportedNamespaces | 未インポート項目表示 |
| SnippetsRule | スニペット表示ルール |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OperationCanceledException | キャンセル | 入力中断 | 正常終了 |
| プロバイダー例外 | 実行時エラー | プロバイダー内部エラー | エラーログ、スキップ |

### リトライ仕様

リトライ処理は存在しない。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- 非同期実行による応答性確保
- 部分セマンティクスによる高速応答
- キャッシュによる効率化
- プロバイダーの優先度フィルタリング

## セキュリティ考慮事項

特になし。

## 備考

- CompletionServiceは言語固有の実装が存在
- CompletionProviderはMEFでエクスポート
- リモートワークスペースでバックグラウンド処理可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスとデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CompletionService.cs | `src/Features/Core/Portable/Completion/CompletionService.cs` | メインサービス |
| 1-2 | CompletionItem.cs | `src/Features/Core/Portable/Completion/CompletionItem.cs` | 補完候補データ |
| 1-3 | CompletionList.cs | `src/Features/Core/Portable/Completion/CompletionList.cs` | 候補リストデータ |

**主要処理フロー (CompletionService.cs)**:
1. **31行目**: abstract class CompletionService、ILanguageService実装
2. **51-52行目**: GetServiceでドキュメントから言語固有サービス取得
3. **65行目**: Language抽象プロパティ
4. **94-110行目**: ShouldTriggerCompletionでトリガー判定
5. **174-178行目**: GetDefaultCompletionListSpanでデフォルトスパン取得
6. **186-193行目**: GetDescriptionAsyncで候補説明取得

#### Step 2: プロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CompletionProvider.cs | `src/Features/Core/Portable/Completion/CompletionProvider.cs` | プロバイダー基底クラス |
| 2-2 | AbstractSymbolCompletionProvider.cs | `src/Features/Core/Portable/Completion/Providers/AbstractSymbolCompletionProvider.cs` | シンボル補完 |

#### Step 3: 具体的なプロバイダー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractKeywordCompletionProvider.cs | `src/Features/Core/Portable/Completion/Providers/AbstractKeywordCompletionProvider.cs` | キーワード補完 |
| 3-2 | AbstractTypeImportCompletionProvider.cs | `src/Features/Core/Portable/Completion/Providers/ImportCompletionProvider/AbstractTypeImportCompletionProvider.cs` | インポート補完 |

### プログラム呼び出し階層図

```
IDE (エディター)
    │
    ├─ 文字入力/Ctrl+Space
    │
    ▼
CompletionService
    │
    ├─ ShouldTriggerCompletion
    │      │
    │      └─ 各プロバイダーのトリガー判定
    │
    ├─ GetCompletionsAsync
    │      │
    │      ├─ ProviderManager.GetFilteredProviders
    │      │
    │      └─ 各CompletionProvider.ProvideCompletionsAsync
    │             │
    │             ├─ SymbolCompletionProvider
    │             │      │
    │             │      └─ Recommender.GetRecommendedSymbolsAtPositionAsync
    │             │
    │             ├─ KeywordCompletionProvider
    │             │
    │             ├─ SnippetCompletionProvider
    │             │
    │             └─ ImportCompletionProvider
    │
    └─ GetChangeAsync (選択時)
           │
           └─ コード変更生成
```

### データフロー図

```
[入力]                         [処理]                          [出力]

Document              ──▶  CompletionService           ──▶  CompletionList
        │                              │
        ▼                              ▼
キャレット位置         ──▶  コンテキスト解析           ──▶  位置情報
        │                              │
        ▼                              ▼
トリガー情報           ──▶  ShouldTriggerCompletion    ──▶  トリガー判定
        │                              │
        ▼                              ▼
SemanticModel         ──▶  シンボル推奨               ──▶  シンボルリスト
        │                              │
        ▼                              ▼
                           CompletionProvider[]
                                    │
                    ┌───────────────┼───────────────┐
                    ▼               ▼               ▼
            シンボル候補      キーワード候補    スニペット候補
                    │               │               │
                    └───────────────┼───────────────┘
                                    ▼
                              マージ/ソート
                                    │
                                    ▼
                              CompletionItem[]
                                    │
                                    ▼
                              IDE表示
                                    │
                                    ▼
                            ユーザー選択
                                    │
                                    ▼
                           GetChangeAsync
                                    │
                                    ▼
                           コード変更
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CompletionService.cs | `src/Features/Core/Portable/Completion/CompletionService.cs` | ソース | メインサービス |
| CompletionProvider.cs | `src/Features/Core/Portable/Completion/CompletionProvider.cs` | ソース | プロバイダー基底 |
| CompletionItem.cs | `src/Features/Core/Portable/Completion/CompletionItem.cs` | ソース | 補完候補データ |
| CompletionList.cs | `src/Features/Core/Portable/Completion/CompletionList.cs` | ソース | 候補リストデータ |
| CompletionTrigger.cs | `src/Features/Core/Portable/Completion/CompletionTrigger.cs` | ソース | トリガー情報 |
| CompletionContext.cs | `src/Features/Core/Portable/Completion/CompletionContext.cs` | ソース | コンテキスト |
| CompletionOptions.cs | `src/Features/Core/Portable/Completion/CompletionOptions.cs` | ソース | オプション |
| AbstractSymbolCompletionProvider.cs | `src/Features/Core/Portable/Completion/Providers/AbstractSymbolCompletionProvider.cs` | ソース | シンボル補完 |
| AbstractKeywordCompletionProvider.cs | `src/Features/Core/Portable/Completion/Providers/AbstractKeywordCompletionProvider.cs` | ソース | キーワード補完 |
